# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if len(my_history) == 0:
        return "C"  # First round: Cooperate
    
    if len(my_history) == 9:  # Final round (Round 10)
        return "D"
    
    # Check if opponent has defected more than twice in the last 5 rounds
    if len(opp_history) >= 5 and sum(1 for move in opp_history[-5:] if move == "D") > 2:
        return "D"
    
    # Tit-for-Tat with 10% forgiveness
    last_opponent_move = opp_history[-1]
    if last_opponent_move == "C":
        return "C"
    else:
        if random.random() < 0.1:  # 10% chance to forgive
            return "C"
        else:
            return "D"